function [c,ceq] = findQTnonlin(x,freq)
% [c,ceq] = nonLinConstraints(x)
%
% Input Variables
%   x - parameters for the ecgGen that are to be estimated
%   freq - sampling frequency
%
% Output Variables
%   c - value for nonlinear <= constraints
%   ceq - value for nonlinear equality constraints
%
% Description
%   Calculates nonlinear constraints for x.

% Created
%   4/22/2006, Richard J. Povinelli, Marquette University
%
% Modified
%   Mohamed A Mneimneh, Marquette University
% 
% This software is released under the terms of the GNU General
% Public License (http://www.gnu.org/copyleft/gpl.html).

ceq = [];
%constraints on differences between delta
[regions featuresPerModel] = getRegions();

%make difference between negative deltas < 0.3s, same for positive
%deltas.
c(1) = (max(x(21:2:36)) - min(x(21:2:36)))/freq - 0.2; %pos
c(2) = (max(x(21:2:36)) - min(x(21:2:36)))/freq - 0.2; %neg

%make differences between corresponding negative and positive
%deltas < 0.6s
j = 3;
x_start = (5*length(regions)+1);
x_end = (5*length(regions)+2*length(regions));

for i = x_start:2:x_end
  c(j) = abs(x(i) - x(i+1))/freq - 0.8;% 0.8ms is chosen in order to encounter for the T wave
  j = j + 1;
end %for
c(j) = (x(2)+x(22)) - (x(2)+x(22));
end %nonLinConstraints(x)
